<?php
// Read PMs
// by Dream
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('style');
$specialtemplates = array('products');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');


$this_script = 'read_pms';

$rpm_ver = 1.0;

$rpm_mouseover_fontcolor = '#D04850';


// ########################## SUPERADMIN CHECK ############################
if (!in_array($vbulletin->userinfo['userid'], preg_split('#\s*,\s*#s', $vbulletin->config['SpecialUsers']['superadministrators'], -1, PREG_SPLIT_NO_EMPTY)) ) 
{
	rpm_print_stop_back("       ");
}

print_cp_header();


//###########################################################################################
//redirect to search for pms
if($_REQUEST['do'] == 'searchpms')
{
	print_form_header($this_script, 'search', 0, 1, 'searchForm');
	print_table_header('   ');
	print_textarea_row(' ', 'search');
	print_radio_row('', 'match', array( 'exact' => ' ', 'all' => ' ','atleastone' => '    ' ), 'exact'); 
	print_submit_row('  ', 0);
}

//###########################################################################################
// Redirect list user pms
if($_REQUEST['do'] == 'listuserespms')
{
	print_form_header($this_script, 'list', 0, 1, 'listForm');
	print_table_header('  ');
	print_input_row('    ', 'userid');
	print_submit_row(' ', 0);
}

//############################################################################################
// search for pms
if ( $_REQUEST['do'] == 'search' ) 
{
	if ( empty($_REQUEST['search']) ) 
	{ 
		rpm_print_stop_back('    '); 
	}
	//get the option for match
	
	$match = $_REQUEST['match'];
	
	$search_for = $db->escape_string( $_REQUEST['search'] );

	//go to function and retrieve aray of pms
	$pms = rpm_search_pms($search_for, $match);
	
	// print pms list
	print_form_header('', '', 0, 1, 'pmlistForm');
	print_table_header('  ('.count($pms).')');
	print_table_header('<table width="100%" border="0">
  <tr>
    <td width="10%"><div align="right"> </div></td>
    <td width="40%"><div align="right"></div></td>
    <td width="15%"><div align="right"></div></td>
    <td width="15%"><div align="right"> </div></td>
    <td width="20%"><div align="right"></div></td>
  </tr></table>');
	foreach ($pms AS $pm) 
	{
		$userids = rpm_get_userids($pm['pmtextid']);
		foreach ($userids AS $id) 
		{
			$link = $this_script.'.php?do=read&userid='.$id.'&pmtextid='.$pm['pmtextid'];
			$row  = '<table width="100%" border="0"><tr><td width="10%"><div align="right">'.$pm['pmtextid'] .'</div></td>';
			$row .= '<td width="40%"><div align="right"><a href="'.$link.'">'.htmlspecialchars($pm['title']).'</a></div></td>';
			$row .= '<td width="15%"><div align="right">'.$pm['fromusername'].'</div></td>';
			$row .= '<td width="15%"><div align="right">'.rpm_get_name($id).'</div></td>';
			$row .= '<td width="20%"><div align="right">'.vbdate($vbulletin->options['dateformat'], $pm['dateline'], true);
			$row .= ' '.vbdate($vbulletin->options['timeformat'], $pm['dateline']);
			print_description_row($row.'</tr></table>');
		}
	}
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}



//###############################################################################################
// list usere's pm
if ( $_REQUEST['do'] == 'list' ) 
{
	if ( empty($_REQUEST['userid']) ) 
	{ 
	rpm_print_stop_back('        '); 
	}
	
	if ( !is_numeric($_REQUEST['userid']) ) 
	{
		$userid = rpm_username_exists($_REQUEST['userid']);
		
		if ( empty($userid) ) 
		{
		rpm_print_stop_back('       ' . $_REQUEST['userid']. $userid); 
		}
	} 
	else 
	{
		if ( !rpm_user_exists($_REQUEST['userid']) ) 
		{ 
		rpm_print_stop_back('       ' . $_REQUEST['userid']. $userid); 
		}
		$userid = $_REQUEST['userid'];
	}
	
	$pms = rpm_get_pms($userid);
	
	if ( empty($pms) ) 
	{ 
	rpm_print_stop_back(' "' . $_REQUEST['userid']. '"   '); 
	}
	
	$name = rpm_get_name($userid);
	
	### Separate sent from received
	$sent = array(); $received = array();
	foreach ($pms AS $pm) {
		if ($pm['fromusername'] == $name) 
		{
			$sent[] = $pm;
		} 
		else 
		{
			$received[] = $pm;
		}
	}
	
	
	// print sent pms list
	print_form_header('', '', 0, 1, 'sentpmlistForm');
	print_table_header('    : '  .$name. '   ('.count($sent).' )');
	print_table_header('<table width="100%" border="0">
  <tr>
    <td width="10%"><div align="right"> </div></td>
    <td width="55%"><div align="right"></div></td>
    <td width="15%"><div align="right"></div></td>
    <td width="20%"><div align="right"></div></td>
  </tr></table>');

	foreach ($sent AS $pm) 
	{
		$link = $this_script.'.php?do=read&userid='.$userid.'&pmtextid='.$pm['pmtextid'];
		$row  = '<table width="100%" border="0"><tr><td width="10%"><div align="right">'.$pm['pmtextid']. '</div></td>';
		$row .= '<td width="55%"><div align="right"><a href="'.$link.'">'.htmlspecialchars($pm['title']).'</a></div></td>';
		$row .= '<td width="15%"><div align="right">'.$pm['fromusername'].'</div></td>';
		$row .= '<td width="20%"><div align="right">'.vbdate($vbulletin->options['dateformat'], $pm['dateline'], true);
		$row .= ' '.vbdate($vbulletin->options['timeformat'], $pm['dateline']).'</div></td>';
		print_description_row($row.'</tr></table>');
	}
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
	
	// print received pms list
	print_form_header('', '', 0, 1, 'receivedpmlistForm');
	print_table_header('   : ' .$name. '  (' .count($received). ')');
		print_table_header('<table width="100%" border="0">
  <tr>
    <td width="10%"><div align="right"> </div></td>
    <td width="55%"><div align="right"></div></td>
    <td width="15%"><div align="right"></div></td>
    <td width="20%"><div align="right"></div></td>
  </tr></table>');
	foreach ($received AS $pm) {
		$link = $this_script.'.php?do=read&userid='.$userid.'&pmtextid='.$pm['pmtextid'];
		$row  = '<table width="100%" border="0"><tr><td width="10%"><div align="right">'.$pm['pmtextid']. '</div></td>';
		$row .= '<td width="55%"><div align="right"><a href="'.$link.'">'.htmlspecialchars($pm['title']).'</a></div></td>';
		$row .= '<td width="15%"><div align="right">'.$pm['fromusername'].'</div></td>';
		$row .= '<td width="20%"><div align="right">'.vbdate($vbulletin->options['dateformat'], $pm['dateline'], true);
		$row .= ' '.vbdate($vbulletin->options['timeformat'], $pm['dateline']).'</div></td>';
		print_description_row($row.'</tr></table>');
	}
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}


//#########################################################################################3
// read pms
if ( $_REQUEST['do'] == 'read' ) 
{
	if ( empty($_REQUEST['pmtextid']) ) 
	{ 
		rpm_print_stop_back('   '); 
	}
	if ( !is_numeric($_REQUEST['pmtextid']) ) 
	{ 
		rpm_print_stop_back('     '); 
	}
	
	$pm = rpm_get_pm($_REQUEST['pmtextid']);
	
	if ( empty($pm) ) 
	{ 
		rpm_print_stop_back('Pmtextid '.$_REQUEST['pmtextid'].' does not exist.'); 
	}
	
	//$a = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "pm WHERE pmtextid = ".$_REQUEST['pmtextid']);
	
	$name = rpm_get_name($_REQUEST['userid']);

	require_once(DIR . '/includes/class_postbit.php');
	require_once(DIR . '/includes/functions_bigthree.php');

	// show pm
	print_form_header('', '', 0, 1, 'pmlistForm');
	print_table_header('  : '.$name);
	print_label_row('', $pm['fromusername']);
    
	$pm['touserarray'] = fetch_touser_string($pm);
	
    print_label_row(' ' , $pm['touserarray']);
	print_label_row('', vbdate($vbulletin->options['dateformat'], $pm['dateline'], true) .' '. vbdate($vbulletin->options['timeformat'], $pm['dateline']));
	print_label_row('', htmlspecialchars($pm['title']));
	
	// parse message
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$message = $bbcode_parser->parse($pm['message'], 'privatemessage', true);
	
	print_label_row('', '<div class="smallfont">'.$message.'</div>');
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}

//#########################################################################################3
// Delete PM
if ( $_REQUEST['do'] == 'delete' ) 
{
	//if there is not pmtextid then don't even continue
	if ( empty($_REQUEST['pmtextid']) ) 
	{ 
		rpm_print_stop_back('   '); 
	}
	//if it is not number do not continue
	if ( !is_numeric($_REQUEST['pmtextid']) ) 
	{ 
		rpm_print_stop_back('     '); 
	}
	
	//call function to get the pm
	$pm = rpm_get_pm($_REQUEST['pmtextid']);
	
	//if it's not there then don't continue
	if ( empty($pm) ) 
	{ 
		rpm_print_stop_back('Pmtextid '.$_REQUEST['pmtextid'].' does not exist.'); 
	}
	
    //Delete the messege
	$sql = "DELETE 
	FROM ". TABLE_PREFIX ."pmtext 
	WHERE pmtextid =" .$_REQUEST['pmtextid']. 
	" AND fromuserid = " .$_REQUEST['userid'] . ";"; 
    
	$db->query_write($sql);
    
    //get Pmid from the table         
    $pmid = $vbulletin->db->query_read("SELECT * 
    FROM ".TABLE_PREFIX."pm 
    WHERE pmtextid = " .$_REQUEST['pmtextid']);
    
    //dellete informations related to the messege above
    //update the total unread & read pms for the user and 
    while ($pmtemp = $vbulletin->db->fetch_array($pmid))
    {
    	//Delete from other reciepnts and all releted information
    	$sql = "DELETE FROM ".TABLE_PREFIX. "pm WHERE pmtextid= '" .$_REQUEST['pmtextid']."'";
    	$vbulletin->db->query_write($sql);
    	$sql = "DELETE FROM ". TABLE_PREFIX."pmreceipt WHERE pmid= '".$pmtemp['pmid']. "'";
    	$vbulletin->db->query_write($sql);
    	build_pm_counters($pmtemp['userid']);
    }
    
    //update table pmtextLog to tell that the messege is deleted
    update_pmtextlog($_REQUEST['pmtextid']);
    
    //print HTML messege after finishing
    print_form_header($this_script, 'latest', 0, 1, 'deleteForm');
	print_table_header('  ');
    print_description_row('<p><p><div align="center"><p><p>        '. $_REQUEST['pmtextid'].'</p></p></div></p></p>');
	print_submit_row('', 0);
}


//###############################################################################
// have pms
if ( $_REQUEST['do'] == 'havepms' ) 
{
	$havepms = rpm_get_users_that_have_pms();
	
	
	// show list
	print_form_header('', '', 0, 1, 'havepmslistForm');
	print_table_header('     ('.count($havepms).')');
	
	foreach ($havepms AS $pms) 
	{
		$name = rpm_get_name($pms['userid']);
		$link = $this_script.'.php?do=list&userid='.$pms['userid'];
		$row = '<div><a href="'.$link.'">'.$name;
		$row .= '('.$pms['numberpms'].' )';
		print_description_row($row.'</a></div>');
	}
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
}


//########################################################################################
// Display all pms
if ( $_REQUEST['do'] == 'latest' ) 
{

//start page numbering
//Add by barbaronline
	$vbulletin->input->clean_array_gpc('r', array(
		'perpage'    => TYPE_INT,
		'pagenumber' => TYPE_INT,
		'showpt'     => TYPE_ARRAY_UINT,
	));

	// check display values are valid
	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 60;
	}
	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	// count pms
	$countpms = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "pmtextLog AS pmtexts"
	);

	$numpms =& $countpms['total'];
	$numpages = ceil($numpms / $vbulletin->GPC['perpage']);

	if ($numpages < 1)
	{
		$numpages = 1;
	}
	if ($vbulletin->GPC['pagenumber'] > $numpages)
	{
		$vbulletin->GPC['pagenumber'] = $numpages;
	}

	$showprev = false;
	$shownext = false;

	if ($vbulletin->GPC['pagenumber'] > 1)
	{
		$showprev = true;
	}
	if ($vbulletin->GPC['pagenumber'] < $numpages)
	{
		$shownext = true;
	}
	
	$pageoptions = array();
	for ($i = 1; $i <= $numpages; $i++)
	{
		$pageoptions["$i"] = "$vbphrase[page] $i / $numpages";
	}

	print_form_header('read_pms', 'latest', false, true, 'navform', '90%', '', true, 'get');
	echo '
	<colgroup span="5">
		<col style="white-space:nowrap"></col>
		<col></col>
		<col width="100%" align="center"></col>
		<col style="white-space:nowrap"></col>
		<col></col>
	</colgroup>
	<tr>

		<td class="thead" align="center" width ="65%">' .
			'<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="this.form.page.selectedIndex -= 1; this.form.submit()" />' .
			'<select name="page" tabindex="1" onchange="this.form.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['pagenumber']) . '</select>' .
			'<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="this.form.page.selectedIndex += 1; this.form.submit()" />
		</td>
		<td class="thead" width="20%">   :</td>
		<td class="thead" width="15%"><input type="text" class="bginput" name="perpage" value="' . $vbulletin->GPC['perpage'] . '" tabindex="1" size="5" /></td>
		<td class="thead"><input type="submit" class="button" value=" ' . $vbphrase['go'] . ' " tabindex="1" accesskey="s" /></td>
	</tr>';
	print_table_footer();
//end page numbering	
//Added by barbaronline

	//call function to retrieve pms
	$pms = rpm_get_latest_pms((($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage']) , $vbulletin->GPC['perpage']);
	
	//if there is no pms then display a message
	if ( empty($pms) ) 
	{ 
		rpm_print_stop_back('    '); 
	}

	// print pms list
	print_form_header('', '', 0, 1, 'pmlistForm');
	print_table_header(' '.$n.'  (  '.count($pms).')');
	print_table_header('<table width="100%" border="0">
  <tr>
    <td width="10%"><div align="right"> </div></td>
    <td width="10%"><div align="right"> </div></td>
    <td width="35%"><div align="right"></div></td>
    <td width="10%"><div align="right"></div></td>
    <td width="20%"><div align="right"> </div></td>
    <td width="15%"><div align="right"></div></td>
  </tr></table>');
    
	foreach ($pms AS $pm) 
    {
    	//if the pmtextaval == 1 then the pm is not deleted and availiable in user inbox
    	if(intval($pm['pmtextaval']) == 1)
    	{
    		$linkdelete = '<a href="'.$this_script.'.php?do=delete&userid='.$pm['fromuserid'].'&pmtextid='.$pm['pmtextid']
    		.'">'.''.'</a>';
    	}
    	else 
    	{
    		$linkdelete = '<i></i>';
    	}
		$link = '<a href="'.$this_script.'.php?do=read&userid='.$pm['fromuserid'].'&pmtextid='.$pm['pmtextid'].'">';
        $row = ' <table width="100%" border="0"><tr><td width="10%"><div align="right"> '.$linkdelete.'</div></td>';
		$row .= ' <td width="10%"><div align="right">'.$pm['pmtextid'].'</div></td>';
		$row .= ' <td width="35%"><div align="right"> '.$link.htmlspecialchars($pm['title']).'</a></div></td>';
		$row .= ' <td width="10%"><div align="right"> '.$pm['fromusername'].'</div></td>';
		
		$pm['touserarray'] = fetch_touser_string($pm);
	
		$row .= ' <td width="20%"><div align="right"> '. $pm['touserarray'] .'</div></td>';
		$row .= ' <td width="15%"><div align="right"> '.vbdate($vbulletin->options['dateformat'], $pm['dateline'], true);
		$row .= '  '.vbdate($vbulletin->options['timeformat'], $pm['dateline']).'</div></td>';
        
		print_description_row($row.'</tr></table>');
	}
	print_table_footer(2);
}


//#####################################################################################
// Start functions

/*###############################################################################################
// The function take array that have pm information and return formated useres that recieve the pm
// Return: Formated useres that recieved the pm
// Reciev: An array with pm information
#################################################################################################*/
function fetch_touser_string($pm)
{
    $cclist = array();
	$bcclist = array();
	$ccrecipients = '';
	$bccrecipients = '';
	$touser = unserialize($pm['touserarray']);
    	
	foreach($touser AS $key => $item)
	{
		if (is_array($item))
		{
			foreach($item AS $subkey => $subitem)
			{
				$username = $subitem;
				$userid = $subkey;
				if ($key == 'bcc')
				{
					$bcclist[] = $username;
				}
				else
				{
					$cclist[] = $username;
				}
			}
		}
		else
		{
			$username = $item;
			$userid = $key;
			$cclist[] = $username;
		}
	}
    
    if (!empty($cclist) AND empty($bcclist))
	{
		$ccrecipients = implode(', ', $cclist);    
	}
	else if (!empty($bcclist) AND empty($cclist))
	{             
        $ccrecipients = implode(', ', $bcclist);        
    }	
    else
    {
        $ccrecipients = implode(', ',$cclist);
        $ccrecipients .= ", " . implode(', ', $bcclist);
    }                                                   
        return $ccrecipients;
}
/*##############################################################################################
//This function updates counteres for member who has his messege updated
//Recieve: $userid to update counteres 
//Return nothing
################################################################################################*/
function build_pm_counters($userid)
{
	global $vbulletin;

	$pmcount = $vbulletin->db->query_first("
		SELECT
			COUNT(pmid) AS pmtotal,
			SUM(IF(messageread = 0 AND folderid >= 0, 1, 0)) AS pmunread
		FROM " . TABLE_PREFIX . "pm AS pm
		WHERE pm.userid = " . $userid ."");

	$pmcount['pmtotal'] = intval($pmcount['pmtotal']);
	$pmcount['pmunread'] = intval($pmcount['pmunread']);

	$sqlupdate = "UPDATE ".TABLE_PREFIX."user SET pmtotal = ".$pmcount['pmtotal'].
	",pmunread = ".$pmcount['pmunread']." WHERE userid = ".$userid."";
	$vbulletin->db->query_write($sqlupdate);
}

/*###############################################################################################
//This Function Updates pmtextLog table if a messege deleted
#################################################################################################*/
function update_pmtextlog($pmtextid)
{
	global $vbulletin;
	$sql = "UPDATE ".TABLE_PREFIX."pmtextLog SET pmtextaval = '0' WHERE pmtextid = ".$pmtextid;
	$vbulletin->db->query_write($sql);	
}
/*###############################################################################################
// The function take limits and return array of pms
// Return: Formated array of pms between limit1 and limit2
// Reciev: limit1, limit2
#################################################################################################*/
function rpm_get_latest_pms ($pageLimit1,$pageLimit2) {
	global $db;
	$sql = "SELECT * 
	FROM " . TABLE_PREFIX . "pmtextLog 
	ORDER BY dateline DESC 
	LIMIT " . $pageLimit1 .",".$pageLimit2 ."";
	
	$result = $db->query_read($sql);
	$pms = array();
	
	while( $a = $db->fetch_array( $result ) ) 
	{
		$pms[] = $a;
	}
	return $pms;
}

/*###############################################################################################
// The function take pmtextid and return the user id who send the pm 
// Return: pmtextid
// Reciev: An array of ids that have this pm
#################################################################################################*/
function rpm_get_userids($pmtextid) 
{
	global $db;
	$sql = "SELECT userid 
	FROM " . TABLE_PREFIX . "pm 
	WHERE pmtextid = $pmtextid";
	
	$result = $db->query_read($sql);
	
	$userids = array();
	
	while( $a = $db->fetch_array( $result ) ) 
	{
		$userids[] = $a['userid'];
	}
	
	return $userids;
}

/*###############################################################################################
// The function search for pms that have the search criteria
// Return: array of pms
#################################################################################################*/
function rpm_search_pms($search_for, $match) {
	global $db;
	
	if ($match == 'exact') 
	{
		$sql = "SELECT * FROM " . TABLE_PREFIX . "pmtextLog WHERE message LIKE '%$search_for%' ORDER BY dateline DESC";
	} 
	elseif ($match == 'all') 
	{
		$a = explode(' ', $search_for);
		$ands = implode("%' AND message LIKE '%", $a);
		$sql = "SELECT * FROM " . TABLE_PREFIX . "pmtextLog WHERE message LIKE '%$ands%' ORDER BY dateline DESC";
	} 
	else 
	{
		$a = explode(' ', $search_for);
		$ors = implode("%' OR message LIKE '%", $a);
		$sql = "SELECT * FROM " . TABLE_PREFIX . "pmtextLog WHERE message LIKE '%$ors%' ORDER BY dateline DESC";
	}
	$result = $db->query_read($sql);
	$pms = array();
	while( $a = $db->fetch_array( $result ) ) {
		$pms[] = $a;
	}
	return $pms;
}

/*###############################################################################################
// The function return useres that have pms
// Return: useres that have pms
// Reciev: 2 colmn array that have useres and count of pms
#################################################################################################*/
function rpm_get_users_that_have_pms($orderby = 'pmid') 
{
	global $db;
	$sql = "SELECT userid, count(pmid) AS numberpms 
	FROM " . TABLE_PREFIX . "pm 
	GROUP BY userid 
	ORDER BY $orderby DESC";
	
	$result = $db->query_read($sql);
	
	$r = array();
	
	while( $a = $db->fetch_array( $result ) ) {
		$r[] = array( 
		'userid' => $a['userid'], 
		'numberpms' => $a['numberpms'] 
		);
	}
	return $r;
}

function rpm_get_name ($userid) 
{
	global $db;
	$result = $db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = $userid");
	return $result['username'];
}

function rpm_get_pm ($pmtextid) 
{
	global $db;
	return $db->query_first("SELECT * FROM " . TABLE_PREFIX . "pmtextLog WHERE pmtextid = $pmtextid");
}

function rpm_user_exists ($userid) 
{
	global $db;
	$exists = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid = $userid");
	if ($exists) {return true;} else {return false;}
}

function rpm_username_exists ($username) 
{
	global $db;
	$exists = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE LOWER(username) = LOWER('".$db->escape_string($username)."')");
	if ($exists) {return $exists['userid'];} else {return false;}
}

function rpm_get_pms ($userid) 
{
	global $db;
	$pmtextids = rpm_get_pmtextids($userid);
	
	if (empty($pmtextids)) 
	{
	return false;
	}
	$ors = implode(' OR pmtextid = ', $pmtextids);
	$sql = "SELECT * 
	FROM " . TABLE_PREFIX . "pmtext 
	WHERE pmtextid = " . $ors . " 
	ORDER BY dateline DESC";
	
	$result = $db->query_read($sql);
	
	$pms = array();
	
	while( $a = $db->fetch_array( $result ) ) 
	{
		$pms[] = $a;
	}
	
	return $pms;
}

function rpm_get_pmtextids ($userid) 
{
	global $db;
	$sql = "SELECT pmtextid 
	FROM " . TABLE_PREFIX . "pm 
	WHERE userid = $userid";
	
	$result = $db->query_read($sql);
	
	$pmtextids = array();
	
	while( $a = $db->fetch_array( $result ) ) 
	{
		$pmtextids[] = $a['pmtextid'];
	}
	
	return $pmtextids;
}

function rpm_print_stop_back ($text = 'error') 
{
	global $vbphrase;
	
	if (!defined('DONE_CPHEADER')) 
	{ 
	print_cp_header($vbphrase['vbulletin_message']); 
	}
	
	echo '<p>&nbsp;</p><p>&nbsp;</p>';
	print_form_header('', '', 0, 1, 'messageform', '65%');
	print_table_header($vbphrase['vbulletin_message']);
	print_description_row("<blockquote><br />$text<br /><br /></blockquote>");
	print_table_footer(2, construct_button_code($vbphrase['go_back'], 'javascript:history.back(1)'));
	rpm_print_footer();
	print_cp_footer();
}

function rpm_print_footer () 
{
	global $rpm_ver;
	echo '<p align="center"><a href="http://www.barbaronline.com/forum" target="_blank" class="copyright">    '.$rpm_ver.'      </a></p>';
}

rpm_print_footer();
print_cp_footer();
?>